string GetDescription()
{
	return "This is an extended random harmony script.\n - Uses all chords on the scale\n - Either one chord per bar or two\n - Subdominant is with 6 and dominant with 7";
}

void GenerateHarmony(UniquePart @up)
{
	int mode = RndInt(1,3);
	if (mode == 3) mode = 1;
	int sec_placement = RndInt(1,up.GetMetrum()-1);
	
	if (up.GetMetrum() == 2) sec_placement = 1;
	if (up.GetMetrum() == 4) sec_placement = 2;
	if (up.GetMetrum() == 3) sec_placement = 2;
	if (up.GetMetrum() == 5) sec_placement = RndInt(2,3);
	if (up.GetMetrum() == 6) sec_placement = 3;
	if (up.GetMetrum() == 7) sec_placement = RndInt(3,4);
	if (up.GetMetrum() == 8) sec_placement = 4;
	
	if (mode == 1)
	{
		up.AddHarmonic(CreateTime(0,0), 1, "135");
		
		for (int i = 1; i < up.GetBars()-2; i++)
		{
			int basis = RndInt(1,7);
			if (basis == 4) up.AddHarmonic(CreateTime(i,0), basis, "1356");
			else if (basis == 5) up.AddHarmonic(CreateTime(i,0), basis, "1357");
			else up.AddHarmonic(CreateTime(i,0), basis, "135");
		}
		
		up.AddHarmonic(CreateTime(up.GetBars()-2,0), 5, "1357");
		up.AddHarmonic(CreateTime(up.GetBars()-1,0), 1, "135");
	}
	else
	{
		up.AddHarmonic(CreateTime(0,0), 1, "135");
		
		for (int i = 0; i < up.GetBars()-1; i++)
		{
			if (i != 0)
			{
				int basis = RndInt(1,7);
				if (basis == 4) up.AddHarmonic(CreateTime(i,0), basis, "1356");
				else if (basis == 5) up.AddHarmonic(CreateTime(i,0), basis, "1357");
				else up.AddHarmonic(CreateTime(i,0), basis, "135");
			}
			if (i != up.GetBars()-2)
			{
				int basis = RndInt(1,7);
				if (basis == 4) up.AddHarmonic(CreateTime(i,sec_placement), basis, "1356");
				else if (basis == 5) up.AddHarmonic(CreateTime(i,sec_placement), basis, "1357");
				else up.AddHarmonic(CreateTime(i,sec_placement), basis, "135");
			}
		}
		
		up.AddHarmonic(CreateTime(up.GetBars()-2,sec_placement), 5, "1357");
		up.AddHarmonic(CreateTime(up.GetBars()-1,0), 1, "135");
	}
}